/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.rcx.materialis.modifiers.CapacitorModifier;
import com.rcx.materialis.util.TinkerToolFluxed;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class FluxburnerModifier
extends CapacitorModifier {
    private static final int ENERGY_COST = 100;

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (isEffective && !tool.isBroken() && TinkerToolFluxed.removeEnergy(tool, 100 * level, true, false)) {
            event.setNewSpeed(event.getNewSpeed() + 2.5f * (float)level * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED));
        }
    }

    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.isAOE() && context.isEffective() && !tool.isBroken()) {
            TinkerToolFluxed.removeEnergy(tool, 100 * level, false, false);
        }
    }

    @Override
    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        super.addInformation(tool, level, player, tooltip, key, flag);
        float bonus = 0.0f;
        if (TinkerToolFluxed.removeEnergy(tool, 100 * level, true, false)) {
            bonus = 2.5f * (float)level;
        }
        this.addStatTooltip(tool, ToolStats.MINING_SPEED, TinkerTags.Items.HARVEST, bonus, tooltip);
    }

    @Override
    public int getCapacity() {
        return 5000;
    }
}

